
## Packages

library(tidyverse)
library(readxl)
library(openxlsx)
library(here)
library(ggplot2)
library(countrycode)
library(lubridate)
library(scales)
library(dplyr)


## Data inputs
data_path <- "raw data"

#trade data
path_to_IM <- file.path(data_path, "trade data/Imports.xlsx")
path_to_EX <-file.path(data_path, "trade data/Exports.xlsx")

#tariff revenue data
path_tariff_rev <- file.path(data_path, "trade data/Calculated duties and CIF imports.xlsx")

#import/export price index - detailed
#this text file includes all available import/export price indices from the BLS and can be accessed through "Text Files" page here; https://www.bls.gov/mxp/data/
price_index <- read.delim("raw data/price index/ei.data.0.Current.txt", header = TRUE, sep = "\t", stringsAsFactors = FALSE)
#this is the file containing detailed series names and information for the indices listed above.
ei_series <- read.delim("raw data/price index/ei.series.txt", header = TRUE, sep = "\t", stringsAsFactors = FALSE)


## Path to save outputs
path_to_output <- here("output-apr to july")

## Run the codes in the following order
source("code/01-processing-apr to july.R")
source("code/02-constructing datasets.R")
source("code/03-price adjustment.R")
source("code/04-export data.R")


